<?php
/**
 * Sistem Test Sayfası
 * Tüm düzeltmelerin çalıştığını test eder
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/security.php';

session_start();
requireLogin();

$page_title = "Sistem Testi";
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="container py-5">
        <h1 class="mb-4"><i class="fas fa-check-circle me-2"></i><?php echo $page_title; ?></h1>
        
        <div class="alert alert-info">
            <h5><i class="fas fa-info-circle me-2"></i>Test Senaryoları</h5>
            <p class="mb-0">Aşağıdaki işlemleri test edin ve sonuçları kontrol edin:</p>
        </div>
        
        <div class="row">
            <!-- Test 1: Satış İşlemi -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">1. Satış İşlemi Testi</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Test Adımları:</strong></p>
                        <ol>
                            <li><a href="../pages/sales.php" target="_blank">Satış sayfasına git</a></li>
                            <li>Bir ürün seç ve sepete ekle</li>
                            <li>Müşteri seç</li>
                            <li>Kısmi ödeme yap (örn: 100 TL'lik satış, 50 TL ödeme)</li>
                            <li>Satışı tamamla</li>
                        </ol>
                        <p><strong>Beklenen Sonuç:</strong></p>
                        <ul>
                            <li>✓ Satış başarıyla kaydedilmeli</li>
                            <li>✓ Müşteri bakiyesi artmalı (borçlu)</li>
                            <li>✓ Stok azalmalı</li>
                            <li>✓ Kalan tutar doğru hesaplanmalı</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Test 2: Ödeme Alma -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">2. Ödeme Alma Testi</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Test Adımları:</strong></p>
                        <ol>
                            <li><a href="../pages/reports.php" target="_blank">Raporlar sayfasına git</a></li>
                            <li>Borçlu bir müşteri bul</li>
                            <li>"Ödeme Al" butonuna tıkla</li>
                            <li>Ödeme tutarı gir</li>
                            <li>Ödemeyi kaydet</li>
                        </ol>
                        <p><strong>Beklenen Sonuç:</strong></p>
                        <ul>
                            <li>✓ Ödeme başarıyla kaydedilmeli</li>
                            <li>✓ Müşteri bakiyesi azalmalı</li>
                            <li>✓ Cari hareket kaydı oluşmalı</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Test 3: Stok Girişi -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0">3. Stok Girişi Testi</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Test Adımları:</strong></p>
                        <ol>
                            <li><a href="../pages/stock_movements.php" target="_blank">Stok Hareketleri sayfasına git</a></li>
                            <li>"Stok Giriş" sekmesine tıkla</li>
                            <li>Ürün seç, miktar ve fiyat gir</li>
                            <li>Tedarikçi seç (opsiyonel)</li>
                            <li>Stok girişi yap</li>
                        </ol>
                        <p><strong>Beklenen Sonuç:</strong></p>
                        <ul>
                            <li>✓ Stok başarıyla artmalı</li>
                            <li>✓ Stok hareketi kaydedilmeli</li>
                            <li>✓ Tedarikçi seçildiyse borç oluşmalı</li>
                            <li>✓ "Veritabanı işlem hatası" OLMAMALI</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Test 4: Stok Durumu -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">4. Stok Durumu Testi</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Test Adımları:</strong></p>
                        <ol>
                            <li><a href="../pages/stock_movements.php" target="_blank">Stok Hareketleri sayfasına git</a></li>
                            <li>"Stok Durumu" sekmesine tıkla</li>
                            <li>Tablo yüklenene kadar bekle</li>
                        </ol>
                        <p><strong>Beklenen Sonuç:</strong></p>
                        <ul>
                            <li>✓ Tablo yüklenmeli (BOŞ OLMAMALI)</li>
                            <li>✓ Tüm ürünler listelenmeli</li>
                            <li>✓ Stok durumları gösterilmeli</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Test 5: Bakiye Kontrolü -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0">5. Bakiye Tutarlılığı Testi</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Test Adımları:</strong></p>
                        <ol>
                            <li><a href="database_analysis.php" target="_blank">Veritabanı Analizi sayfasına git</a></li>
                            <li>Bakiye tutarsızlıklarını kontrol et</li>
                        </ol>
                        <p><strong>Beklenen Sonuç:</strong></p>
                        <ul>
                            <li>✓ Bakiye tutarsızlığı: 0</li>
                            <li>✓ Negatif müşteri bakiyesi: 0</li>
                            <li>✓ Satış tutarsızlığı: 0</li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Test 6: Transaction Testi -->
            <div class="col-md-6 mb-4">
                <div class="card">
                    <div class="card-header bg-secondary text-white">
                        <h5 class="mb-0">6. Transaction Hatası Testi</h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Test Adımları:</strong></p>
                        <ol>
                            <li>Yukarıdaki tüm işlemleri yap</li>
                            <li>Hata mesajlarını kontrol et</li>
                        </ol>
                        <p><strong>Beklenen Sonuç:</strong></p>
                        <ul>
                            <li>✓ "Transaction no active" hatası OLMAMALI</li>
                            <li>✓ "Veritabanı işlem hatası" OLMAMALI</li>
                            <li>✓ Tüm işlemler başarılı olmalı</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="alert alert-success mt-4">
            <h5><i class="fas fa-check-circle me-2"></i>Test Sonuçları</h5>
            <p>Tüm testleri tamamladıktan sonra:</p>
            <ul class="mb-0">
                <li>Başarılı testleri işaretleyin</li>
                <li>Hata alan testleri not edin</li>
                <li>Sonuçları geliştiriciye bildirin</li>
            </ul>
        </div>
        
        <div class="text-center mt-4">
            <a href="../pages/dashboard.php" class="btn btn-primary">
                <i class="fas fa-arrow-left me-2"></i>Dashboard'a Dön
            </a>
            <a href="database_analysis.php" class="btn btn-info">
                <i class="fas fa-database me-2"></i>Veritabanı Analizi
            </a>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
