<?php

define('DEBUG_MODE', true);
define('LOG_ERRORS', true);
define('DISPLAY_ERRORS', DEBUG_MODE);

if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);
    ini_set('display_errors', 0);
}

ini_set('log_errors', LOG_ERRORS);
ini_set('error_log', __DIR__ . '/../logs/php_errors.log');

define('CSRF_TOKEN_EXPIRE', 3600);
define('SESSION_TIMEOUT', 7200);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900);

define('MAX_UPLOAD_SIZE', 10 * 1024 * 1024);
define('UPLOAD_PATH', __DIR__ . '/../uploads/');

define('DB_HOST', 'localhost');
define('DB_NAME', 'depo_stok_takip');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

define('APP_NAME', 'Depo Stok Takip Sistemi');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'http://localhost/mulakat');

define('MAIL_HOST', 'smtp.gmail.com');
define('MAIL_PORT', 587);
define('MAIL_USERNAME', '');
define('MAIL_PASSWORD', '');
define('MAIL_ENCRYPTION', 'tls');

define('PAGINATION_LIMIT', 20);
define('CACHE_ENABLED', false);
define('CACHE_DURATION', 3600);

function getBaseUrl() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];
    $path = dirname($script);
    
    return $protocol . '://' . $host . $path;
}

function formatCurrency($amount) {
    return '₺' . number_format($amount, 2, ',', '.');
}

function formatDate($date, $format = 'd.m.Y H:i') {
    if (empty($date) || $date === '0000-00-00 00:00:00') {
        return '-';
    }
    return date($format, strtotime($date));
}

function generateRandomString($length = 32) {
    return bin2hex(random_bytes($length / 2));
}

function isAjaxRequest() {
    return isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 
           strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
}

function jsonResponse($data, $status = 200) {
    http_response_code($status);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit();
}

function redirectTo($url, $message = null, $type = 'info') {
    if ($message) {
        $_SESSION['flash_message'] = $message;
        $_SESSION['flash_type'] = $type;
    }
    header('Location: ' . $url);
    exit();
}

function getFlashMessage() {
    if (isset($_SESSION['flash_message'])) {
        $message = $_SESSION['flash_message'];
        $type = $_SESSION['flash_type'] ?? 'info';
        unset($_SESSION['flash_message'], $_SESSION['flash_type']);
        return ['message' => $message, 'type' => $type];
    }
    return null;
}

function logActivity($action, $details = null) {
    if (!isset($_SESSION['user_id'])) return;
    
    try {
        require_once __DIR__ . '/database.php';
        $database = Database::getInstance();
        
        $sql = "INSERT INTO activity_log (user_id, action, details, ip_address, user_agent, created_at) 
                VALUES (?, ?, ?, ?, ?, NOW())";
        
        $database->execute($sql, [
            $_SESSION['user_id'],
            $action,
            $details ? json_encode($details) : null,
            $_SERVER['REMOTE_ADDR'] ?? '',
            $_SERVER['HTTP_USER_AGENT'] ?? ''
        ]);
    } catch (Exception $e) {
        error_log("Activity log error: " . $e->getMessage());
    }
}

function sanitizeFilename($filename) {
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '_', $filename);
    $filename = preg_replace('/_{2,}/', '_', $filename);
    return trim($filename, '_');
}

function getFileExtension($filename) {
    return strtolower(pathinfo($filename, PATHINFO_EXTENSION));
}

function isValidImageExtension($extension) {
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    return in_array(strtolower($extension), $allowed);
}

function isValidDocumentExtension($extension) {
    $allowed = ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'txt', 'csv'];
    return in_array(strtolower($extension), $allowed);
}

function createDirectory($path) {
    if (!is_dir($path)) {
        return mkdir($path, 0755, true);
    }
    return true;
}

function deleteFile($filepath) {
    if (file_exists($filepath)) {
        return unlink($filepath);
    }
    return true;
}

?>