<?php

/**
 * Veritabanı Yapılandırma Dosyası (Örnek)
 * 
 * Bu dosyayı database.php olarak kopyalayın ve kendi bilgilerinizle doldurun.
 */

require_once __DIR__ . '/config.php';

class Database {
    private static $instance = null;
    private $host = 'localhost';
    private $db_name = 'depo_stok_takip';
    private $username = 'root';
    private $password = '';
    private $charset = 'utf8mb4';
    private $pdo;
    private $error;

    public function __construct() {
        $this->connect();
    }

    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function connect() {
        $dsn = "mysql:host={$this->host};dbname={$this->db_name};charset={$this->charset}";
        
        $options = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ];

        try {
            $this->pdo = new PDO($dsn, $this->username, $this->password, $options);
        } catch (PDOException $e) {
            $this->error = $e->getMessage();
            error_log("Database connection error: " . $this->error);
            throw new Exception("Veritabanı bağlantı hatası");
        }
    }

    // ... diğer metodlar database.php dosyasından kopyalanmalı
}

?>
