<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once '../includes/security.php';
require_once '../includes/authorization.php';
require_once '../config/database.php';

requireLogin();

Authorization::requirePageAccess('sales', 'okuma');

$error_message = '';
$success_message = '';

if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) {
    header('Content-Type: application/json');
    
    try {
        validateCSRF();
        
        Authorization::requirePageAccess('sales', 'yazma');
        
        $action = $_POST['action'] ?? '';
        
        if ($action === 'add_to_cart') {
            $urun_id = (int)($_POST['urun_id'] ?? 0);
            $miktar = (int)($_POST['miktar'] ?? 1);
            
            if ($urun_id <= 0 || $miktar <= 0) {
                throw new Exception('Geçersiz ürün veya miktar.');
            }
            
            $sql = "SELECT * FROM urunler WHERE urun_id = ?";
            $product = $database->fetch($sql, [$urun_id]);
            
            if (!$product) {
                throw new Exception('Ürün bulunamadı.');
            }
            
            $current_cart_qty = $_SESSION['cart'][$urun_id]['miktar'] ?? 0;
            $total_qty = $current_cart_qty + $miktar;
            
            if ($total_qty > $product['stok_miktari']) {
                throw new Exception('Yetersiz stok. Mevcut stok: ' . $product['stok_miktari']);
            }
            
            if (isset($_SESSION['cart'][$urun_id])) {
                $_SESSION['cart'][$urun_id]['miktar'] += $miktar;
            } else {
                $_SESSION['cart'][$urun_id] = [
                    'urun_id' => $urun_id,
                    'urun_adi' => $product['urun_adi'],
                    'satis_fiyati' => $product['satis_fiyati'],
                    'miktar' => $miktar
                ];
            }
            
            echo json_encode(['success' => true, 'message' => 'Ürün sepete eklendi.']);
            
        } elseif ($action === 'update_cart') {
            $urun_id = (int)($_POST['urun_id'] ?? 0);
            $miktar = (int)($_POST['miktar'] ?? 0);
            
            if ($miktar <= 0) {
                unset($_SESSION['cart'][$urun_id]);
            } else {
                $sql = "SELECT stok_miktari FROM urunler WHERE urun_id = ?";
                $product = $database->fetch($sql, [$urun_id]);
                
                if ($miktar > $product['stok_miktari']) {
                    throw new Exception('Yetersiz stok. Mevcut stok: ' . $product['stok_miktari']);
                }
                
                if (isset($_SESSION['cart'][$urun_id])) {
                    $_SESSION['cart'][$urun_id]['miktar'] = $miktar;
                }
            }
            
            echo json_encode(['success' => true, 'message' => 'Sepet güncellendi.']);
            
        } elseif ($action === 'remove_from_cart') {
            $urun_id = (int)($_POST['urun_id'] ?? 0);
            unset($_SESSION['cart'][$urun_id]);
            
            echo json_encode(['success' => true, 'message' => 'Ürün sepetten çıkarıldı.']);
            
        } elseif ($action === 'get_cart') {
            // Sepet içeriğini HTML olarak döndür
            $cart_total = 0;
            $cart_count = 0;
            foreach ($_SESSION['cart'] as $item) {
                $cart_total += $item['satis_fiyati'] * $item['miktar'];
                $cart_count += $item['miktar'];
            }
            
            ob_start();
            if (empty($_SESSION['cart'])) {
                ?>
                <div class="text-center py-5">
                    <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                    <p class="text-muted">Sepet boş</p>
                </div>
                <?php
            } else {
                foreach ($_SESSION['cart'] as $item) {
                    ?>
                    <div class="cart-item mb-3 p-3 border rounded" data-product-id="<?php echo $item['urun_id']; ?>">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="flex-grow-1">
                                <h6 class="mb-1"><?php echo Security::escapeOutput($item['urun_adi']); ?></h6>
                                <small class="text-muted">₺<?php echo number_format($item['satis_fiyati'], 2); ?> / adet</small>
                            </div>
                            <button class="btn btn-outline-danger btn-sm" onclick="removeFromCart(<?php echo $item['urun_id']; ?>)">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-2">
                            <div class="d-flex align-items-center">
                                <button class="btn btn-outline-secondary btn-sm" onclick="updateQuantity(<?php echo $item['urun_id']; ?>, -1)">-</button>
                                <input type="number" 
                                       class="form-control quantity-input mx-2" 
                                       value="<?php echo $item['miktar']; ?>"
                                       min="1"
                                       onchange="updateCartQuantity(<?php echo $item['urun_id']; ?>, this.value)">
                                <button class="btn btn-outline-secondary btn-sm" onclick="updateQuantity(<?php echo $item['urun_id']; ?>, 1)">+</button>
                            </div>
                            <strong>₺<?php echo number_format($item['satis_fiyati'] * $item['miktar'], 2); ?></strong>
                        </div>
                    </div>
                    <?php
                }
                
                // Müşteri listesini al
                $sql = "SELECT cari_id, cari_adi, cari_tipi FROM cariler WHERE cari_tipi = 'musteri' ORDER BY cari_adi ASC";
                $customers = $database->fetchAll($sql);
                ?>
                
                <div class="border-top pt-3">
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Toplam:</strong>
                        <strong class="text-primary">₺<?php echo number_format($cart_total, 2); ?></strong>
                    </div>
                    
                    <form method="POST" id="saleForm">
                        <?php echo Security::getCSRFTokenInput(); ?>
                        <input type="hidden" name="complete_sale" value="1">
                        
                        <div class="mb-3">
                            <label class="form-label">Müşteri *</label>
                            <select name="cari_id" class="form-select" required>
                                <option value="">Müşteri seçiniz...</option>
                                <?php foreach ($customers as $customer): ?>
                                    <option value="<?php echo $customer['cari_id']; ?>">
                                        <?php echo Security::escapeOutput($customer['cari_adi']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Ödenen Tutar (₺)</label>
                            <input type="number" 
                                   name="odenen_tutar" 
                                   class="form-control" 
                                   step="0.01" 
                                   min="0" 
                                   max="<?php echo $cart_total; ?>"
                                   value="<?php echo $cart_total; ?>">
                        </div>
                        
                        <button type="submit" class="btn btn-success w-100">
                            <i class="fas fa-check me-2"></i>
                            Satışı Tamamla
                        </button>
                    </form>
                </div>
                <?php
            }
            $cart_html = ob_get_clean();
            
            echo json_encode([
                'success' => true, 
                'cart_html' => $cart_html,
                'cart_total' => $cart_total,
                'cart_count' => $cart_count
            ]);
            
        } elseif ($action === 'complete_sale') {
            $cari_id = (int)($_POST['cari_id'] ?? 0);
            $odenen_tutar = (float)($_POST['odenen_tutar'] ?? 0);
            
            if (empty($_SESSION['cart'])) {
                throw new Exception('Sepet boş.');
            }
            
            if ($cari_id <= 0) {
                throw new Exception('Cari seçiniz.');
            }
            
            $sql = "SELECT * FROM cariler WHERE cari_id = ?";
            $customer = $database->fetch($sql, [$cari_id]);
            if (!$customer) {
                throw new Exception('Cari bulunamadı.');
            }
            
            $toplam_tutar = 0;
            foreach ($_SESSION['cart'] as $item) {
                $toplam_tutar += $item['satis_fiyati'] * $item['miktar'];
            }
            
            if ($odenen_tutar < 0) {
                throw new Exception('Ödenen tutar negatif olamaz.');
            }
            
            $database->beginTransaction();
            
            try {
                $kalan_tutar = $toplam_tutar - $odenen_tutar;
                $sql = "INSERT INTO satislar (cari_id, toplam_tutar, odenen_tutar, kalan_tutar, kullanici_id, satis_tarihi) VALUES (?, ?, ?, ?, ?, NOW())";
                $database->execute($sql, [$cari_id, $toplam_tutar, $odenen_tutar, $kalan_tutar, $_SESSION['user_id']]);
                $satis_id = $database->lastInsertId();
                
                foreach ($_SESSION['cart'] as $item) {
                    $sql = "SELECT stok_miktari FROM urunler WHERE urun_id = ?";
                    $product = $database->fetch($sql, [$item['urun_id']]);
                    
                    if ($product['stok_miktari'] < $item['miktar']) {
                        throw new Exception($item['urun_adi'] . ' için yetersiz stok.');
                    }
                    
                    $sql = "INSERT INTO satis_detay (satis_id, urun_id, adet, birim_fiyat) VALUES (?, ?, ?, ?)";
                    $database->execute($sql, [$satis_id, $item['urun_id'], $item['miktar'], $item['satis_fiyati']]);
                    
                    $sql = "UPDATE urunler SET stok_miktari = stok_miktari - ? WHERE urun_id = ?";
                    $database->execute($sql, [$item['miktar'], $item['urun_id']]);
                }
                
                // Cari hareket kayıtları için BalanceManager kullan
                require_once '../includes/balance_manager.php';
                $balanceManager = new BalanceManager($database);
                
                // Borç kaydı (toplam tutar)
                $balanceManager->addMovementAndUpdateBalance($cari_id, 'borc', $toplam_tutar, 
                    "Satış No: $satis_id", $satis_id);
                
                // Alacak kaydı (ödenen tutar, eğer varsa)
                if ($odenen_tutar > 0) {
                    $balanceManager->addMovementAndUpdateBalance($cari_id, 'alacak', $odenen_tutar, 
                        "Satış No: $satis_id - Ödeme", $satis_id);
                }
                
                $database->commit();
                
                $_SESSION['cart'] = [];
                
                echo json_encode([
                    'success' => true, 
                    'message' => 'Satış başarıyla tamamlandı. Satış No: ' . $satis_id
                ]);
                
            } catch (Exception $e) {
                $database->rollback();
                throw $e;
            }
        }
        
    } catch (Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['complete_sale'])) {
    try {
        validateCSRF();
        
        $cari_id = (int)($_POST['cari_id'] ?? 0);
        $odenen_tutar = (float)($_POST['odenen_tutar'] ?? 0);
        
        if (empty($_SESSION['cart'])) {
            throw new Exception('Sepet boş.');
        }
        
        if ($cari_id <= 0) {
            throw new Exception('Cari seçiniz.');
        }
        
        $sql = "SELECT * FROM cariler WHERE cari_id = ?";
        $customer = $database->fetch($sql, [$cari_id]);
        if (!$customer) {
            throw new Exception('Cari bulunamadı.');
        }
        
        $toplam_tutar = 0;
        foreach ($_SESSION['cart'] as $item) {
            $toplam_tutar += $item['satis_fiyati'] * $item['miktar'];
        }
        
        if ($odenen_tutar < 0) {
            throw new Exception('Ödenen tutar negatif olamaz.');
        }
        
        $database->beginTransaction();
        
        try {
            $kalan_tutar = $toplam_tutar - $odenen_tutar;
            $sql = "INSERT INTO satislar (cari_id, toplam_tutar, odenen_tutar, kalan_tutar, kullanici_id, satis_tarihi) VALUES (?, ?, ?, ?, ?, NOW())";
            $database->execute($sql, [$cari_id, $toplam_tutar, $odenen_tutar, $kalan_tutar, $_SESSION['user_id']]);
            $satis_id = $database->lastInsertId();
            
            foreach ($_SESSION['cart'] as $item) {
                $sql = "SELECT stok_miktari FROM urunler WHERE urun_id = ?";
                $product = $database->fetch($sql, [$item['urun_id']]);
                
                if ($product['stok_miktari'] < $item['miktar']) {
                    throw new Exception($item['urun_adi'] . ' için yetersiz stok.');
                }
                
                $sql = "INSERT INTO satis_detay (satis_id, urun_id, adet, birim_fiyat) VALUES (?, ?, ?, ?)";
                $database->execute($sql, [$satis_id, $item['urun_id'], $item['miktar'], $item['satis_fiyati']]);
                
                $sql = "UPDATE urunler SET stok_miktari = stok_miktari - ? WHERE urun_id = ?";
                $database->execute($sql, [$item['miktar'], $item['urun_id']]);
            }
            
            // Cari hareket kayıtları için BalanceManager kullan
            require_once '../includes/balance_manager.php';
            $balanceManager = new BalanceManager($database);
            
            // Borç kaydı (toplam tutar)
            $balanceManager->addMovementAndUpdateBalance($cari_id, 'borc', $toplam_tutar, 
                "Satış No: $satis_id", $satis_id);
            
            // Alacak kaydı (ödenen tutar, eğer varsa)
            if ($odenen_tutar > 0) {
                $balanceManager->addMovementAndUpdateBalance($cari_id, 'alacak', $odenen_tutar, 
                    "Satış No: $satis_id - Ödeme", $satis_id);
            }
            
            $database->commit();
            
            $_SESSION['cart'] = [];
            
            $success_message = 'Satış başarıyla tamamlandı. Satış No: ' . $satis_id;
            
        } catch (Exception $e) {
            $database->rollback();
            throw $e;
        }
        
    } catch (Exception $e) {
        $error_message = $e->getMessage();
    }
}

$search = Security::sanitizeInput($_GET['search'] ?? '');
$where_conditions = ["stok_miktari > 0"];
$params = [];

if (!empty($search)) {
    $where_conditions[] = "(urun_adi LIKE ? OR barkod LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$where_clause = 'WHERE ' . implode(' AND ', $where_conditions);
$sql = "SELECT * FROM urunler $where_clause ORDER BY urun_adi ASC LIMIT 50";
$products = $database->fetchAll($sql, $params);

$sql = "SELECT cari_id, cari_adi, cari_tipi FROM cariler WHERE cari_tipi = 'musteri' ORDER BY cari_adi ASC";
$customers = $database->fetchAll($sql);

$cart_total = 0;
$cart_count = 0;
foreach ($_SESSION['cart'] as $item) {
    $cart_total += $item['satis_fiyati'] * $item['miktar'];
    $cart_count += $item['miktar'];
}

$page_title = "Ürün Satış";
include '../includes/header.php';
?>

<style>
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        }
        .btn {
            border-radius: 10px;
        }
        .form-control {
            border-radius: 10px;
            border: 2px solid #e9ecef;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        .product-card {
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        .product-card:hover {
            border-color: #667eea;
            transform: translateY(-2px);
        }
        .cart-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: bold;
        }
        .cart-sidebar {
            position: fixed;
            top: 0;
            right: -400px;
            width: 400px;
            height: 100vh;
            background: white;
            box-shadow: -2px 0 10px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            z-index: 1001;
            overflow-y: auto;
        }
        .cart-sidebar.active {
            right: 0;
        }

        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 999;
            display: none;
        }
        .overlay.active {
            display: block;
        }
        .quantity-input {
            width: 80px;
            text-align: center;
        }
    </style>
</head>
<body>

<input type="hidden" name="csrf_token" value="<?php echo Security::generateCSRFToken(); ?>">


<?php include '../includes/sidebar.php'; ?>


<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">

    
    <div class="cart-sidebar" id="cartSidebar">
        <div class="p-3 border-bottom">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-shopping-cart me-2"></i>
                    Sepet
                </h5>
                <button class="btn btn-outline-secondary btn-sm" id="closeCart">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        
        <div class="p-3" id="cartContent">
            <?php if (empty($_SESSION['cart'])): ?>
                <div class="text-center py-5">
                    <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                    <p class="text-muted">Sepet boş</p>
                </div>
            <?php else: ?>
                <?php foreach ($_SESSION['cart'] as $item): ?>
                    <div class="cart-item mb-3 p-3 border rounded" data-product-id="<?php echo $item['urun_id']; ?>">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="flex-grow-1">
                                <h6 class="mb-1"><?php echo Security::escapeOutput($item['urun_adi']); ?></h6>
                                <small class="text-muted">₺<?php echo number_format($item['satis_fiyati'], 2); ?> / adet</small>
                            </div>
                            <button class="btn btn-outline-danger btn-sm" onclick="removeFromCart(<?php echo $item['urun_id']; ?>)">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mt-2">
                            <div class="d-flex align-items-center">
                                <button class="btn btn-outline-secondary btn-sm" onclick="updateQuantity(<?php echo $item['urun_id']; ?>, -1)">-</button>
                                <input type="number" 
                                       class="form-control quantity-input mx-2" 
                                       value="<?php echo $item['miktar']; ?>"
                                       min="1"
                                       onchange="updateCartQuantity(<?php echo $item['urun_id']; ?>, this.value)">
                                <button class="btn btn-outline-secondary btn-sm" onclick="updateQuantity(<?php echo $item['urun_id']; ?>, 1)">+</button>
                            </div>
                            <strong>₺<?php echo number_format($item['satis_fiyati'] * $item['miktar'], 2); ?></strong>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <div class="border-top pt-3">
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Toplam:</strong>
                        <strong class="text-primary">₺<?php echo number_format($cart_total, 2); ?></strong>
                    </div>
                    
                    <form method="POST" id="saleForm">
                        <?php echo Security::getCSRFTokenInput(); ?>
                        <input type="hidden" name="complete_sale" value="1">
                        
                        <div class="mb-3">
                            <label class="form-label">Müşteri *</label>
                            <select name="cari_id" class="form-select" required>
                                <option value="">Müşteri seçiniz...</option>
                                <?php foreach ($customers as $customer): ?>
                                    <option value="<?php echo $customer['cari_id']; ?>">
                                        <?php echo Security::escapeOutput($customer['cari_adi']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Ödenen Tutar (₺)</label>
                            <input type="number" 
                                   name="odenen_tutar" 
                                   class="form-control" 
                                   step="0.01" 
                                   min="0" 
                                   max="<?php echo $cart_total; ?>"
                                   value="<?php echo $cart_total; ?>">
                        </div>
                        

                        
                        <button type="submit" class="btn btn-success w-100">
                            <i class="fas fa-check me-2"></i>
                            Satışı Tamamla
                        </button>
                    </form>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="overlay" id="overlay"></div>

    
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">
            <button class="btn btn-outline-secondary d-md-none me-2" type="button" id="sidebarToggle">
                <i class="fas fa-bars"></i>
            </button>
            <?php echo $page_title; ?>
        </h1>
        <div class="btn-toolbar mb-2 mb-md-0">
            <button class="btn btn-outline-success me-3 position-relative" id="cartToggle">
                <i class="fas fa-shopping-cart"></i>
                <?php if ($cart_count > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                        <?php echo $cart_count; ?>
                    </span>
                <?php endif; ?>
            </button>
            <a href="dashboard.php" class="btn btn-sm btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i>Dashboard'a Dön
            </a>
        </div>
    </div>

    
    <div class="container-fluid">
            <?php if ($error_message): ?>
                <div class="alert alert-danger" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <?php echo Security::escapeOutput($error_message); ?>
                </div>
            <?php endif; ?>

            <?php if ($success_message): ?>
                <div class="alert alert-success" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo Security::escapeOutput($success_message); ?>
                </div>
            <?php endif; ?>

            
            <div class="row mb-4">
                <div class="col-md-6">
                    <form method="GET" class="d-flex">
                        <input type="text" 
                               class="form-control me-2" 
                               name="search" 
                               placeholder="Ürün adı veya barkod ara..."
                               value="<?php echo Security::escapeOutput($search); ?>">
                        <button type="submit" class="btn btn-outline-primary">
                            <i class="fas fa-search"></i>
                        </button>
                    </form>
                </div>
                <div class="col-md-6 text-end">
                    <?php if (!empty($_SESSION['cart'])): ?>
                        <span class="text-muted">Sepet Toplamı: </span>
                        <strong class="text-primary">₺<?php echo number_format($cart_total, 2); ?></strong>
                    <?php endif; ?>
                </div>
            </div>

            
            <?php if (empty($products)): ?>
                <div class="text-center py-5">
                    <i class="fas fa-boxes fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Ürün bulunamadı</h5>
                    <p class="text-muted">
                        <?php if (!empty($search)): ?>
                            Arama kriterlerinize uygun stokta ürün bulunamadı.
                        <?php else: ?>
                            Stokta satılabilir ürün bulunmuyor.
                        <?php endif; ?>
                    </p>
                    <a href="products.php" class="btn btn-primary">
                        <i class="fas fa-boxes me-2"></i>
                        Ürün Yönetimi
                    </a>
                </div>
            <?php else: ?>
                <div class="row">
                    <?php foreach ($products as $product): ?>
                        <div class="col-md-4 col-lg-3 mb-4">
                            <div class="card product-card h-100" onclick="showAddToCartModal(<?php echo $product['urun_id']; ?>, '<?php echo Security::escapeOutput($product['urun_adi']); ?>', <?php echo $product['satis_fiyati']; ?>, <?php echo $product['stok_miktari']; ?>)">
                                <div class="card-body">
                                    <h6 class="card-title"><?php echo Security::escapeOutput($product['urun_adi']); ?></h6>
                                    <?php if ($product['barkod']): ?>
                                        <small class="text-muted d-block mb-2">
                                            <i class="fas fa-barcode me-1"></i>
                                            <?php echo Security::escapeOutput($product['barkod']); ?>
                                        </small>
                                    <?php endif; ?>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-primary fw-bold">₺<?php echo number_format($product['satis_fiyati'], 2); ?></span>
                                        <span class="badge <?php echo $product['stok_miktari'] < 10 ? 'bg-warning' : 'bg-success'; ?>">
                                            Stok: <?php echo $product['stok_miktari']; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="modal fade" id="addToCartModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Sepete Ekle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <strong id="modalProductName"></strong>
                        <div class="text-muted">Birim Fiyat: ₺<span id="modalProductPrice"></span></div>
                        <div class="text-muted">Mevcut Stok: <span id="modalProductStock"></span></div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Miktar</label>
                        <input type="number" id="modalQuantity" class="form-control" value="1" min="1">
                    </div>
                    <div class="mb-3">
                        <strong>Toplam: ₺<span id="modalTotal">0.00</span></strong>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-primary" onclick="addToCart()">Sepete Ekle</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let currentProductId = 0;
        let currentProductPrice = 0;
        let currentProductStock = 0;

        const sidebarToggle = document.getElementById('sidebarToggle');
        const sidebar = document.getElementById('sidebar');
        const mainContent = document.getElementById('mainContent');
        const overlay = document.getElementById('overlay');
        const cartToggle = document.getElementById('cartToggle');
        const cartSidebar = document.getElementById('cartSidebar');
        const closeCart = document.getElementById('closeCart');

        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
            
            if (window.innerWidth > 768) {
                mainContent.classList.toggle('shifted');
            }
        });

        cartToggle.addEventListener('click', function() {
            cartSidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        });

        closeCart.addEventListener('click', function() {
            cartSidebar.classList.remove('active');
            overlay.classList.remove('active');
        });

        overlay.addEventListener('click', function() {
            sidebar.classList.remove('active');
            cartSidebar.classList.remove('active');
            overlay.classList.remove('active');
            mainContent.classList.remove('shifted');
        });

        function showAddToCartModal(productId, productName, productPrice, productStock) {
            currentProductId = productId;
            currentProductPrice = productPrice;
            currentProductStock = productStock;
            
            document.getElementById('modalProductName').textContent = productName;
            document.getElementById('modalProductPrice').textContent = productPrice.toFixed(2);
            document.getElementById('modalProductStock').textContent = productStock;
            document.getElementById('modalQuantity').value = 1;
            document.getElementById('modalQuantity').max = productStock;
            
            updateModalTotal();
            
            new bootstrap.Modal(document.getElementById('addToCartModal')).show();
        }

        function updateModalTotal() {
            const quantity = parseInt(document.getElementById('modalQuantity').value) || 0;
            const total = quantity * currentProductPrice;
            document.getElementById('modalTotal').textContent = total.toFixed(2);
        }

        document.getElementById('modalQuantity').addEventListener('input', updateModalTotal);

        function addToCart() {
            const quantity = parseInt(document.getElementById('modalQuantity').value);
            
            if (quantity <= 0 || quantity > currentProductStock) {
                alert('Geçersiz miktar.');
                return;
            }
            
            const formData = new FormData();
            formData.append('ajax', '1');
            formData.append('action', 'add_to_cart');
            formData.append('urun_id', currentProductId);
            formData.append('miktar', quantity);
            formData.append('csrf_token', document.querySelector('input[name="csrf_token"]').value);
            
            // Modal butonunu devre dışı bırak
            const addBtn = document.querySelector('#addToCartModal .btn-primary');
            const originalText = addBtn.innerHTML;
            addBtn.disabled = true;
            addBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Ekleniyor...';
            
            fetch('sales.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    bootstrap.Modal.getInstance(document.getElementById('addToCartModal')).hide();
                    updateCartDisplay(); // Sepeti güncelle
                    
                    // Başarı mesajını göster
                    showSuccessMessage(data.message);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Bir hata oluştu.');
            })
            .finally(() => {
                // Butonu tekrar aktif et
                addBtn.disabled = false;
                addBtn.innerHTML = originalText;
            });
        }
        
        function showSuccessMessage(message) {
            // Geçici başarı mesajı göster
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-success alert-dismissible fade show position-fixed';
            alertDiv.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
            alertDiv.innerHTML = `
                <i class="fas fa-check-circle me-2"></i>${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            document.body.appendChild(alertDiv);
            
            // 3 saniye sonra otomatik kaldır
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 3000);
        }

        function updateQuantity(productId, change) {
            const input = document.querySelector(`[data-product-id="${productId}"] .quantity-input`);
            const newValue = parseInt(input.value) + change;
            
            if (newValue > 0) {
                updateCartQuantity(productId, newValue);
            }
        }

        function updateCartQuantity(productId, quantity) {
            const formData = new FormData();
            formData.append('ajax', '1');
            formData.append('action', 'update_cart');
            formData.append('urun_id', productId);
            formData.append('miktar', quantity);
            formData.append('csrf_token', document.querySelector('input[name="csrf_token"]').value);
            
            fetch('sales.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateCartDisplay();
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Bir hata oluştu.');
            });
        }

        function removeFromCart(productId) {
            if (!confirm('Bu ürünü sepetten çıkarmak istediğinizden emin misiniz?')) {
                return;
            }
            
            const formData = new FormData();
            formData.append('ajax', '1');
            formData.append('action', 'remove_from_cart');
            formData.append('urun_id', productId);
            formData.append('csrf_token', document.querySelector('input[name="csrf_token"]').value);
            
            fetch('sales.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateCartDisplay();
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Bir hata oluştu.');
            });
        }

        function updateCartDisplay() {
            // AJAX ile sepet içeriğini güncelle
            const formData = new FormData();
            formData.append('ajax', '1');
            formData.append('action', 'get_cart');
            formData.append('csrf_token', document.querySelector('input[name="csrf_token"]').value);
            
            fetch('sales.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Sepet içeriğini güncelle
                    document.getElementById('cartContent').innerHTML = data.cart_html;
                    
                    // Sepet sayısını güncelle
                    const cartBadge = document.querySelector('#cartToggle .badge');
                    if (data.cart_count > 0) {
                        if (cartBadge) {
                            cartBadge.textContent = data.cart_count;
                        } else {
                            const badge = document.createElement('span');
                            badge.className = 'position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger';
                            badge.textContent = data.cart_count;
                            document.getElementById('cartToggle').appendChild(badge);
                        }
                    } else {
                        if (cartBadge) {
                            cartBadge.remove();
                        }
                    }
                    
                    // Sepet toplamını güncelle
                    const cartTotalElement = document.querySelector('.text-primary strong');
                    if (cartTotalElement && data.cart_total > 0) {
                        cartTotalElement.textContent = '₺' + parseFloat(data.cart_total).toLocaleString('tr-TR', {minimumFractionDigits: 2});
                    }
                } else {
                    console.error('Cart update failed:', data.message);
                }
            })
            .catch(error => {
                console.error('Error updating cart:', error);
            });
        }

        function completeSale() {
            const form = document.getElementById('saleForm');
            const formData = new FormData(form);
            formData.append('ajax', '1');
            formData.append('action', 'complete_sale');
            
            const cariId = formData.get('cari_id');
            if (!cariId) {
                alert('Lütfen bir müşteri seçiniz.');
                return;
            }
            
            if (!confirm('Satışı tamamlamak istediğinizden emin misiniz?')) {
                return;
            }
            
            // Satış butonunu devre dışı bırak
            const submitBtn = form.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>İşleniyor...';
            
            fetch('sales.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Başarı mesajını göster
                    const alertDiv = document.createElement('div');
                    alertDiv.className = 'alert alert-success';
                    alertDiv.innerHTML = '<i class="fas fa-check-circle me-2"></i>' + data.message;
                    
                    // Mevcut alert'leri temizle
                    const existingAlerts = document.querySelectorAll('.alert');
                    existingAlerts.forEach(alert => alert.remove());
                    
                    // Yeni alert'i ekle
                    const container = document.querySelector('.container-fluid');
                    container.insertBefore(alertDiv, container.firstChild);
                    
                    // Sepeti temizle ve güncelle
                    updateCartDisplay();
                    
                    // Form'u sıfırla
                    form.reset();
                    
                    // 3 saniye sonra alert'i kaldır
                    setTimeout(() => {
                        alertDiv.remove();
                    }, 3000);
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Bir hata oluştu.');
            })
            .finally(() => {
                // Satış butonunu tekrar aktif et
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            });
        }

        document.getElementById('saleForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            completeSale();
        });
    </script>
</main>

<?php include '../includes/footer.php'; ?>