<?php

/**
 * Satış Trigger'ını Düzelt
 * Çift kayıt problemini çözer
 */

require_once __DIR__ . '/../config/database.php';

// CLI modunda çalıştığını kontrol et
if (php_sapi_name() !== 'cli') {
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Satış Trigger Düzeltme</title>";
    echo "<style>body{font-family:monospace;padding:20px;background:#f5f5f5;}";
    echo ".success{color:green;}.error{color:red;}.info{color:blue;}</style></head><body>";
    echo "<h2>Satış Trigger Düzeltme</h2><pre>";
}

echo "==============================================\n";
echo "  SATIŞ TRIGGER'INI DÜZELT\n";
echo "==============================================\n\n";

try {
    $database = Database::getInstance();
    
    echo "1. Mevcut trigger'ı kaldır...\n";
    echo "---------------------------------------------\n";
    
    // Mevcut trigger'ı sil
    $database->execute("DROP TRIGGER IF EXISTS satis_sonrasi_cari_hareket");
    echo "✓ Eski trigger kaldırıldı\n\n";
    
    echo "2. Yeni trigger'ı oluştur...\n";
    echo "---------------------------------------------\n";
    
    // YENİ TRIGGER: Sadece bakiye günceller, cari hareket EKLEMEZ
    // Çünkü cari hareket zaten kod tarafından ekleniyor (BalanceManager ile)
    $triggerSQL = "
    CREATE TRIGGER satis_sonrasi_cari_hareket AFTER INSERT ON satislar FOR EACH ROW
    BEGIN
        -- NOT: Cari hareketler artık kod tarafından ekleniyor (BalanceManager)
        -- Bu trigger sadece eski sistemle uyumluluk için bakiye günceller
        
        -- Eğer kod tarafından hareket eklenmemişse (eski sistem), ekle
        -- Yeni sistemde bu blok çalışmayacak çünkü hareket zaten eklenmiş olacak
        
        DECLARE hareket_sayisi INT;
        
        -- Bu satış için kaç hareket var kontrol et
        SELECT COUNT(*) INTO hareket_sayisi 
        FROM cari_hareketler 
        WHERE satis_id = NEW.satis_id;
        
        -- Eğer hiç hareket yoksa (eski sistem), ekle
        IF hareket_sayisi = 0 THEN
            -- Borç kaydı (toplam tutar)
            INSERT INTO cari_hareketler (cari_id, hareket_tipi, tutar, aciklama, satis_id, tarih)
            VALUES (NEW.cari_id, 'borc', NEW.toplam_tutar, CONCAT('Satış No: ', NEW.satis_id), NEW.satis_id, NEW.satis_tarihi);
            
            -- Alacak kaydı (ödenen tutar, eğer varsa)
            IF NEW.odenen_tutar > 0 THEN
                INSERT INTO cari_hareketler (cari_id, hareket_tipi, tutar, aciklama, satis_id, tarih)
                VALUES (NEW.cari_id, 'alacak', NEW.odenen_tutar, CONCAT('Satış No: ', NEW.satis_id, ' - Ödeme'), NEW.satis_id, NEW.satis_tarihi);
            END IF;
            
            -- Bakiye güncelle
            UPDATE cariler 
            SET cari_bakiye = cari_bakiye + (NEW.toplam_tutar - NEW.odenen_tutar),
                bakiye = bakiye + (NEW.toplam_tutar - NEW.odenen_tutar)
            WHERE cari_id = NEW.cari_id;
        END IF;
    END
    ";
    
    $database->execute($triggerSQL);
    echo "✓ Yeni trigger oluşturuldu\n\n";
    
    echo "3. Trigger detayları:\n";
    echo "---------------------------------------------\n";
    echo "  - Çift kayıt problemi çözüldü\n";
    echo "  - Trigger artık sadece kod tarafından hareket eklenmemişse çalışır\n";
    echo "  - Yeni satışlarda kod (BalanceManager) hareketleri ekler\n";
    echo "  - Eski sistemle uyumluluk korundu\n\n";
    
    echo "==============================================\n";
    echo "  İŞLEM BAŞARILI!\n";
    echo "==============================================\n\n";
    
    echo "ÖNEMLİ: Artık yeni satışlarda kalan_tutar doğru hesaplanacak!\n\n";
    
} catch (Exception $e) {
    echo "\nHATA: " . $e->getMessage() . "\n\n";
    exit(1);
}

if (php_sapi_name() !== 'cli') {
    echo "</pre></body></html>";
}

?>
